<?php
require_once("../config/session.php");
require_once("../config/connection.php");

// Verify user is logged in
confirm_logged_in();

// Verify CSRF token
if (!csrf_verify($_GET['csrf_token'] ?? null)) {
    http_response_code(403);
    die('Invalid CSRF token');
}

// Sanitize and validate ID parameter
$id = get_int('DEL');

if ($id > 0) {
    // Delete the menu item from the database
    $query = "DELETE FROM app_menu WHERE id=?";
    
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param("i", $id);
    
    if ($stmt->execute()) {
        $stmt->close();
        header('Location: ../pages/list_pages.php?deletemenu=1');
        exit();
    } else {
        error_log("Error deleting menu item ID $id: " . $stmt->error);
        $stmt->close();
        header('Location: ../pages/list_pages.php?error=delete_failed');
        exit();
    }
} else {
    http_response_code(400);
    die('Invalid menu ID');
}
?>
